#pragma once

#include "variable.h"

/**********************************************************************************************************************************************************************************
 * 1Channel ODC Variables
 * *******************************************************************************************************************************************************************************/
class VariablesInput
{
	public:
		EtherCATInputFloat fwdPowerSetPoint;
		EtherCATInputFloat frequencySetPoint;
		EtherCATInputFloat sweepStartFrequency;
		EtherCATInputFloat sweepStopFrequency;
		EtherCATInputFloat sweepStepFrequency;
		EtherCATInputFloat sweepPower;
		EtherCATInputFloat dllLowerFrequency;
		EtherCATInputFloat dllUpperFrequency;
		EtherCATInputFloat dllStartFrequency;
		EtherCATInputFloat dllStepFrequency;
		EtherCATInputFloat dllThreshold;
		EtherCATInputUInt16 commands;
		EtherCATInputUInt16 phase;
		EtherCATInputUInt16 phaseGainBoardPhase1;
		EtherCATInputUInt16 phaseGainBoardPhase2;
		EtherCATInputUInt16 phaseGainBoardPhase3;
		EtherCATInputUInt16 phaseGainBoardPhase4;
		EtherCATInputUInt8 dllDelay;
		EtherCATInputUInt8 clockSource;
		EtherCATInputUInt8 pwmDutyCycle;
		
		VariablesInput (EtherCATSlave *slave);
};

class VariablesOutput
{
	public:
		EtherCATOutputUInt64 sgError;
		EtherCATOutputFloat fwdPowerSetPoint;
		EtherCATOutputFloat fwdPower;
		EtherCATOutputFloat rflPower;
		EtherCATOutputFloat returnLoss;
		EtherCATOutputFloat actualFrequency;
		EtherCATOutputFloat s11Frequency;
		EtherCATOutputFloat s11Amplitude;
		EtherCATOutputFloat amplitudeSweepStartFrequency;
		EtherCATOutputFloat amplitudeSweepStopFrequency;
		EtherCATOutputFloat sweepStartFrequency;
		EtherCATOutputFloat sweepStopFrequency;
		EtherCATOutputFloat sweepStepFrequency;
		EtherCATOutputFloat sweepPower;
		EtherCATOutputFloat pwmFrequency;
		EtherCATOutputUInt16 status;
		EtherCATOutputUInt16 temperature;
		EtherCATOutputUInt16 psu1Voltage;
		EtherCATOutputUInt16 psu1Current;
		EtherCATOutputUInt16 psu1Power;
		EtherCATOutputUInt16 psu2Voltage;
		EtherCATOutputUInt16 psu2Current;
		EtherCATOutputUInt16 psu2Power;
		EtherCATOutputUInt16 psu3Voltage;
		EtherCATOutputUInt16 psu3Current;
		EtherCATOutputUInt16 psu3Power;
		EtherCATOutputUInt16 psu4Voltage;
		EtherCATOutputUInt16 psu4Current;
		EtherCATOutputUInt16 psu4Power;
		EtherCATOutputUInt16 psuPowerEfficiency;
		EtherCATOutputUInt16 psuPowerDissipation;
		EtherCATOutputUInt16 phase;
		EtherCATOutputUInt16 phaseGainBoardPhase1;
		EtherCATOutputUInt16 phaseGainBoardPhase2;
		EtherCATOutputUInt16 phaseGainBoardPhase3;
		EtherCATOutputUInt16 phaseGainBoardPhase4;
		EtherCATOutputUInt8 pwmDutyCycle;
		EtherCATOutputUInt8 clockSource;
		
		EtherCATOutputUInt16* psuVoltage[4] {&psu1Voltage, &psu2Voltage, &psu3Voltage, &psu4Voltage};
		EtherCATOutputUInt16* psuCurrent[4] {&psu1Current, &psu2Current, &psu3Current, &psu4Current};
		EtherCATOutputUInt16* psuPower[4] {&psu1Power, &psu2Power, &psu3Power, &psu4Power};
		
		EtherCATOutputUInt16* phaseGainBoardPhase[4] {&phaseGainBoardPhase1, &phaseGainBoardPhase2,
													  &phaseGainBoardPhase3, &phaseGainBoardPhase4};
		
		VariablesOutput (EtherCATSlave *slave);
};


/**********************************************************************************************************************************************************************************
 * 1Channel Variables
 * *******************************************************************************************************************************************************************************/
class VariablesInput_1channel
{
	public:
		EtherCATInputFloat frequency_set_CH1;
		EtherCATInputFloat power_watt_set_CH1;
		EtherCATInputFloat SWP_freq_lower_set_CH1;
		EtherCATInputFloat SWP_freq_upper_set_CH1;
		EtherCATInputFloat SWP_freq_step_set_CH1;
		EtherCATInputFloat SWP_power_watt_set_CH1;
		EtherCATInputFloat DLL_freq_lower_set_CH1;
		EtherCATInputFloat DLL_freq_upper_set_CH1;
		EtherCATInputFloat DLL_freq_start_set_CH1;
		EtherCATInputFloat DLL_freq_step_set_CH1;
		EtherCATInputFloat DLL_threshold_set_CH1;
		EtherCATInputUInt16 commands_set_bitmask;
		EtherCATInputUInt16 phase_set_CH1;
//		EtherCATInputUInt16 splitter_phase1_set;
//		EtherCATInputUInt16 splitter_phase2_set;
//		EtherCATInputUInt16 splitter_phase3_set;
//		EtherCATInputUInt16 splitter_phase4_set;
		EtherCATInputUInt8 DLL_delay_set_CH1;
		EtherCATInputUInt8 clock_source_set_CH1;
		EtherCATInputUInt8 PWM_duty_cycle_set_CH1;

		VariablesInput_1channel (EtherCATSlave *slave);
};

class VariablesOutput_1channel
{
	public:
		EtherCATOutputUInt64 error_bitmask_CH1;
		EtherCATOutputFloat frequency_get_CH1;
		EtherCATOutputFloat power_watt_get_CH1;
		EtherCATOutputFloat FWD_power_watt_CH1;
		EtherCATOutputFloat RFL_power_watt_CH1;
		EtherCATOutputFloat S11_CH1;
		EtherCATOutputFloat SWP_frequency_best_match_CH1;
		EtherCATOutputFloat SWP_S11_best_match_CH1;
		EtherCATOutputFloat SWP_S11_freq_lower_CH1;
		EtherCATOutputFloat SWP_S11_freq_upper_CH1;
		EtherCATOutputFloat SWP_freq_lower_get_CH1;
		EtherCATOutputFloat SWP_freq_upper_get_CH1;
		EtherCATOutputFloat SWP_freq_step_get_CH1;
		EtherCATOutputFloat SWP_power_watt_get_CH1;
		EtherCATOutputFloat PWM_frequency_get_CH1;

		EtherCATOutputUInt16 status_bitmask_CH1;
		EtherCATOutputUInt16 PA_temperature_CH1;
		EtherCATOutputUInt16 PSU1_voltage;
		EtherCATOutputUInt16 PSU1_current;
		EtherCATOutputUInt16 PSU1_power;
		EtherCATOutputUInt16 PSU2_voltage;
		EtherCATOutputUInt16 PSU2_current;
		EtherCATOutputUInt16 PSU2_power;
		EtherCATOutputUInt16 PSU3_voltage;
		EtherCATOutputUInt16 PSU3_current;
		EtherCATOutputUInt16 PSU3_power;
		EtherCATOutputUInt16 PSU4_voltage;
		EtherCATOutputUInt16 PSU4_current;
		EtherCATOutputUInt16 PSU4_power;
		EtherCATOutputUInt16 PSU_power_efficiency;
		EtherCATOutputUInt16 PSU_power_dissipation;
		EtherCATOutputUInt16 phase_get_CH1;
//		EtherCATOutputUInt16 splitter_phase1_get;
//		EtherCATOutputUInt16 splitter_phase2_get;
//		EtherCATOutputUInt16 splitter_phase3_get;
//		EtherCATOutputUInt16 splitter_phase4_get;
		EtherCATOutputUInt8 PWM_duty_cycle_get_CH1;
		EtherCATOutputUInt8 clock_source_get_CH1;

		EtherCATOutputUInt16* psuVoltage[4] {&PSU1_voltage, &PSU2_voltage, &PSU3_voltage, &PSU4_voltage};
		EtherCATOutputUInt16* psuCurrent[4] {&PSU1_current, &PSU2_current, &PSU3_current, &PSU4_current};
		EtherCATOutputUInt16* psuPower[4] {&PSU1_power, &PSU2_power, &PSU3_power, &PSU4_power};

//		EtherCATOutputUInt16* phaseGainBoardPhase[4] {&splitter_phase1_get, &splitter_phase2_get,
//													  &splitter_phase3_get, &splitter_phase4_get};

		VariablesOutput_1channel (EtherCATSlave *slave);
};


/**********************************************************************************************************************************************************************************
 * 4Channel Variables
 * *******************************************************************************************************************************************************************************/
class VariablesInput_4channel
{
	public:
		EtherCATInputUInt16 frequency_set_CH1;
		EtherCATInputUInt16 frequency_set_CH2;
		EtherCATInputUInt16 frequency_set_CH3;
		EtherCATInputUInt16 frequency_set_CH4;

		EtherCATInputUInt16 power_watt_set_CH1;
		EtherCATInputUInt16 power_watt_set_CH2;
		EtherCATInputUInt16 power_watt_set_CH3;
		EtherCATInputUInt16 power_watt_set_CH4;

		EtherCATInputUInt16 VGA_attenuation_set_CH1;
		EtherCATInputUInt16 VGA_attenuation_set_CH2;
		EtherCATInputUInt16 VGA_attenuation_set_CH3;
		EtherCATInputUInt16 VGA_attenuation_set_CH4;

		EtherCATInputUInt16 IQMod_magnitude_set_CH1;
		EtherCATInputUInt16 IQMod_magnitude_set_CH2;
		EtherCATInputUInt16 IQMod_magnitude_set_CH3;
		EtherCATInputUInt16 IQMod_magnitude_set_CH4;

		EtherCATInputUInt16 DLL_freq_lower_set_CH1;
		EtherCATInputUInt16 DLL_freq_lower_set_CH2;
		EtherCATInputUInt16 DLL_freq_lower_set_CH3;
		EtherCATInputUInt16 DLL_freq_lower_set_CH4;

		EtherCATInputUInt16 DLL_freq_upper_set_CH1;
		EtherCATInputUInt16 DLL_freq_upper_set_CH2;
		EtherCATInputUInt16 DLL_freq_upper_set_CH3;
		EtherCATInputUInt16 DLL_freq_upper_set_CH4;

		EtherCATInputUInt16 DLL_freq_start_set_CH1;
		EtherCATInputUInt16 DLL_freq_start_set_CH2;
		EtherCATInputUInt16 DLL_freq_start_set_CH3;
		EtherCATInputUInt16 DLL_freq_start_set_CH4;

		EtherCATInputUInt16 DLL_freq_step_set_CH1;
		EtherCATInputUInt16 DLL_freq_step_set_CH2;
		EtherCATInputUInt16 DLL_freq_step_set_CH3;
		EtherCATInputUInt16 DLL_freq_step_set_CH4;

		EtherCATInputUInt16 DLL_threshold_set_CH1;
		EtherCATInputUInt16 DLL_threshold_set_CH2;
		EtherCATInputUInt16 DLL_threshold_set_CH3;
		EtherCATInputUInt16 DLL_threshold_set_CH4;

//		EtherCATInputUInt16 DLL_delay_set_CH1;
//		EtherCATInputUInt16 DLL_delay_set_CH2;
//		EtherCATInputUInt16 DLL_delay_set_CH3;
//		EtherCATInputUInt16 DLL_delay_set_CH4;

		EtherCATInputUInt16 SWP_freq_lower_set_CH1;
		EtherCATInputUInt16 SWP_freq_lower_set_CH2;
		EtherCATInputUInt16 SWP_freq_lower_set_CH3;
		EtherCATInputUInt16 SWP_freq_lower_set_CH4;

		EtherCATInputUInt16 SWP_freq_upper_set_CH1;
		EtherCATInputUInt16 SWP_freq_upper_set_CH2;
		EtherCATInputUInt16 SWP_freq_upper_set_CH3;
		EtherCATInputUInt16 SWP_freq_upper_set_CH4;

		EtherCATInputUInt16 SWP_freq_step_set_CH1;
		EtherCATInputUInt16 SWP_freq_step_set_CH2;
		EtherCATInputUInt16 SWP_freq_step_set_CH3;
		EtherCATInputUInt16 SWP_freq_step_set_CH4;

		EtherCATInputUInt16 SWP_power_watt_CH1;
		EtherCATInputUInt16 SWP_power_watt_CH2;
		EtherCATInputUInt16 SWP_power_watt_CH3;
		EtherCATInputUInt16 SWP_power_watt_CH4;

		EtherCATInputUInt8  RFE_DLL_set_bitmask;
		EtherCATInputUInt8  feedforward_enable_set_bitmask;
		EtherCATInputUInt8  ERRC_SWP_execute_bitmask;

//		EtherCATInputUInt8 error_clear_bitmask;

//		EtherCATInputUInt8 RF_enable_set_bitmask;

		VariablesInput_4channel (EtherCATSlave *slave);
};

class VariablesOutput_4channel
{
	public:
		EtherCATOutputUInt64 error_status_CH1;
		EtherCATOutputUInt64 error_status_CH2;
		EtherCATOutputUInt64 error_status_CH3;
		EtherCATOutputUInt64 error_status_CH4;

		EtherCATOutputUInt16 frequency_get_CH1;
		EtherCATOutputUInt16 frequency_get_CH2;
		EtherCATOutputUInt16 frequency_get_CH3;
		EtherCATOutputUInt16 frequency_get_CH4;

		EtherCATOutputUInt16 power_watt_get_CH1;
		EtherCATOutputUInt16 power_watt_get_CH2;
		EtherCATOutputUInt16 power_watt_get_CH3;
		EtherCATOutputUInt16 power_watt_get_CH4;

		EtherCATOutputUInt16 FWD_power_watt_CH1;
		EtherCATOutputUInt16 FWD_power_watt_CH2;
		EtherCATOutputUInt16 FWD_power_watt_CH3;
		EtherCATOutputUInt16 FWD_power_watt_CH4;

		EtherCATOutputUInt16 RFL_power_watt_CH1;
		EtherCATOutputUInt16 RFL_power_watt_CH2;
		EtherCATOutputUInt16 RFL_power_watt_CH3;
		EtherCATOutputUInt16 RFL_power_watt_CH4;

		EtherCATOutputUInt16 VGA_attenuation_get_CH1;
		EtherCATOutputUInt16 VGA_attenuation_get_CH2;
		EtherCATOutputUInt16 VGA_attenuation_get_CH3;
		EtherCATOutputUInt16 VGA_attenuation_get_CH4;

		EtherCATOutputUInt16 IQMod_magnitude_get_CH1;
		EtherCATOutputUInt16 IQMod_magnitude_get_CH2;
		EtherCATOutputUInt16 IQMod_magnitude_get_CH3;
		EtherCATOutputUInt16 IQMod_magnitude_get_CH4;

		EtherCATOutputUInt16 Best_S11_Freq_CH1;
		EtherCATOutputUInt16 Best_S11_Freq_CH2;
		EtherCATOutputUInt16 Best_S11_Freq_CH3;
		EtherCATOutputUInt16 Best_S11_Freq_CH4;

		EtherCATOutputUInt16 Best_S11_dB_CH1;
		EtherCATOutputUInt16 Best_S11_dB_CH2;
		EtherCATOutputUInt16 Best_S11_dB_CH3;
		EtherCATOutputUInt16 Best_S11_dB_CH4;

		EtherCATOutputUInt8  RFE_DLL_get_bitmask;
		EtherCATOutputUInt8  feedforward_enable_get_bitmask;

//		EtherCATOutputUInt8 RF_enable_get_bitmask;

		VariablesOutput_4channel (EtherCATSlave *slave);
};
